/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.reflect.BetterSurvivalReflect;
import com.charles445.rltweaker.util.CompatUtil;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class BetterSurvivalHandler {
    private final UUID UUID_BLINDNESS;
    private final UUID UUID_COMPENSATION;
    private final UUID UUID_SPEED;
    BetterSurvivalReflect reflector;

    public BetterSurvivalHandler() {
        block2: {
            this.UUID_BLINDNESS = UUID.fromString("a6107045-134f-4c14-a645-75c3ae5c7a27");
            this.UUID_COMPENSATION = UUID.fromString("a6107045-134f-4c04-a645-75c3ae5c7a27");
            this.UUID_SPEED = UUID.fromString("e6107045-134f-4c54-a645-75c3ae5c7a27");
            try {
                this.reflector = new BetterSurvivalReflect();
                CompatUtil.wrapSpecificHandler("BSBreak", x$0 -> new BSBreak((IEventListener)x$0), "com.mujmajnkraft.bettersurvival.eventhandlers.ModEnchantmentHandler", "onEvent(Lnet/minecraftforge/event/world/BlockEvent$BreakEvent;)");
                CompatUtil.wrapSpecificHandler("BSComboBlindness", x$0 -> new BSComboBlindness((IEventListener)x$0), "com.mujmajnkraft.bettersurvival.eventhandlers.ModWeaponHandler", "onEvent(Lnet/minecraftforge/event/entity/living/LivingEvent$LivingUpdateEvent;)");
                CompatUtil.wrapSpecificHandler("BSArrowSpawn", x$0 -> new BSArrowSpawn((IEventListener)x$0), "com.mujmajnkraft.bettersurvival.eventhandlers.ModEnchantmentHandler", "onEvent(Lnet/minecraftforge/event/entity/EntityJoinWorldEvent;)");
                CompatUtil.wrapSpecificHandler("BSEnchantment", x$0 -> new BSEnchantment((IEventListener)x$0), "com.mujmajnkraft.bettersurvival.eventhandlers.ModEnchantmentHandler", "onEvent(Lnet/minecraftforge/event/entity/living/LivingEvent$LivingUpdateEvent;)");
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup BetterSurvivalHandler!", (Throwable)e);
                ErrorUtil.logSilent("Better Survival Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    @Nullable
    private Enchantment getEnchantmentByName(String name) {
        return (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)new ResourceLocation("mujmajnkraftsbettersurvival", name));
    }

    public class BSBreak {
        @Nullable
        private Enchantment tunneling;
        private boolean disabled = false;
        private IEventListener handler;

        public BSBreak(IEventListener handler) {
            this.handler = handler;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onBreakLowest(BlockEvent.BreakEvent event) {
            if (!ModConfig.server.bettersurvival.tunnelingCancelable) {
                return;
            }
            this.onBreakAny(event);
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
        public void onBreakHighCancel(BlockEvent.BreakEvent event) {
            if (ModConfig.server.bettersurvival.tunnelingCancelable) {
                return;
            }
            this.onBreakAny(event);
        }

        public void onBreakAny(BlockEvent.BreakEvent event) {
            EntityPlayer player;
            if (this.disabled) {
                this.handler.invoke((Event)event);
                return;
            }
            if (this.tunneling == null) {
                this.tunneling = BetterSurvivalHandler.this.getEnchantmentByName("tunneling");
                if (this.tunneling == null) {
                    RLTweaker.logger.warn("Couldn't find tunneling enchantment");
                    ErrorUtil.logSilent("Better Survival Missing Enchantment Tunneling");
                    this.disabled = true;
                    this.handler.invoke((Event)event);
                    return;
                }
            }
            if (EnchantmentHelper.func_185284_a((Enchantment)this.tunneling, (EntityLivingBase)(player = event.getPlayer())) == 0) {
                return;
            }
            World world = event.getWorld();
            int tunnelingLevel = MathHelper.func_76125_a((int)EnchantmentHelper.func_185284_a((Enchantment)this.tunneling, (EntityLivingBase)player), (int)0, (int)200);
            boolean tagNorth = player.func_184216_O().contains("north");
            boolean tagEast = player.func_184216_O().contains("east");
            boolean tagSouth = player.func_184216_O().contains("south");
            boolean tagWest = player.func_184216_O().contains("west");
            boolean tagUp = player.func_184216_O().contains("up");
            boolean tagDown = player.func_184216_O().contains("down");
            boolean isBlacklistEnabled = ModConfig.server.bettersurvival.tunnelingBlacklistEnabled;
            boolean isWhitelist = ModConfig.server.bettersurvival.tunnelingBlacklistIsWhitelist;
            String[] blacklist = ModConfig.server.bettersurvival.tunnelingBlacklist;
            for (int x = -tunnelingLevel; x <= tunnelingLevel; ++x) {
                if ((tagWest || tagEast) && x != 0) continue;
                for (int y = -tunnelingLevel; y <= tunnelingLevel; ++y) {
                    if ((tagUp || tagDown) && y != 0) continue;
                    for (int z = -tunnelingLevel; z <= tunnelingLevel; ++z) {
                        boolean isNotCenter;
                        if ((tagNorth || tagSouth) && z != 0) continue;
                        boolean isInRadius = Math.sqrt(x * x + y * y + z * z) <= (double)(((float)tunnelingLevel + 1.0f) / 2.0f);
                        boolean bl = isNotCenter = x != 0 || y != 0 || z != 0;
                        if (!isInRadius || !isNotCenter) continue;
                        BlockPos newpos = event.getPos().func_177982_a(x, y, z);
                        if (!ModConfig.server.bettersurvival.tunnelingBreaksTileEntities && world.func_175625_s(newpos) != null) {
                            return;
                        }
                        Block block = world.func_180495_p(newpos).func_177230_c();
                        if (block == Blocks.field_150350_a || !isBlacklistEnabled) continue;
                        String blockRegistry = block.getRegistryName().toString();
                        boolean inBlacklist = false;
                        for (String entry : blacklist) {
                            if (!entry.equals(blockRegistry)) continue;
                            inBlacklist = true;
                            break;
                        }
                        if (inBlacklist == isWhitelist) continue;
                        return;
                    }
                }
            }
            this.handler.invoke((Event)event);
        }
    }

    public class BSArrowSpawn {
        private IEventListener handler;

        public BSArrowSpawn(IEventListener handler) {
            this.handler = handler;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
        public void onArrowJoinWorld(EntityJoinWorldEvent event) {
            double rangeSpeedMultiplier = ModConfig.server.bettersurvival.rangeSpeedMultiplier;
            if (rangeSpeedMultiplier == 2.0) {
                this.handler.invoke((Event)event);
                return;
            }
            if (event.getEntity() instanceof EntityArrow && !event.getWorld().field_72995_K) {
                EntityArrow arrowEntity = (EntityArrow)event.getEntity();
                if (arrowEntity.field_70250_c instanceof EntityLivingBase) {
                    double cachedX = arrowEntity.field_70159_w;
                    double cachedY = arrowEntity.field_70181_x;
                    double cachedZ = arrowEntity.field_70179_y;
                    this.handler.invoke((Event)event);
                    if (cachedX != arrowEntity.field_70159_w || cachedY != arrowEntity.field_70181_x || cachedZ != arrowEntity.field_70179_y) {
                        arrowEntity.field_70159_w = cachedX * rangeSpeedMultiplier;
                        arrowEntity.field_70181_x = cachedY * rangeSpeedMultiplier;
                        arrowEntity.field_70179_y = cachedZ * rangeSpeedMultiplier;
                    }
                }
            }
        }
    }

    public class BSComboBlindness {
        private IEventListener handler;
        private boolean replaceComboHandler;

        public BSComboBlindness(IEventListener handler) {
            this.handler = handler;
            this.replaceComboHandler = ModConfig.server.bettersurvival.replaceComboHandler;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        private void replacedComboHandler(LivingEvent.LivingUpdateEvent event) {
            if (event.getEntityLiving() instanceof EntityLiving) {
                EntityLiving living = (EntityLiving)event.getEntityLiving();
                living.func_110148_a(SharedMonsterAttributes.field_111265_b).func_188479_b(BetterSurvivalHandler.this.UUID_BLINDNESS);
                if (living.func_70660_b(MobEffects.field_76440_q) != null) {
                    AttributeModifier modifier = new AttributeModifier(BetterSurvivalHandler.this.UUID_BLINDNESS, "blind", -0.8, 1);
                    living.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(modifier);
                }
            } else if (event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_188479_b(BetterSurvivalHandler.this.UUID_COMPENSATION);
                if (BetterSurvivalHandler.this.reflector.hasINunchakuCombo(player)) {
                    Object combo = BetterSurvivalHandler.this.reflector.getINunchakuCombo(player);
                    try {
                        if (BetterSurvivalHandler.this.reflector.c_ItemNunchaku.isInstance(player.func_184614_ca().func_77973_b())) {
                            if (BetterSurvivalHandler.this.reflector.getComboPower(combo) > 0.0f) {
                                BetterSurvivalHandler.this.reflector.countDown(combo);
                            }
                        } else {
                            BetterSurvivalHandler.this.reflector.setComboTime(combo, 0);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        ErrorUtil.logSilent("BetterSurvival Nunchaku Combo Invocation");
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
        public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
            IAttributeInstance follow_range;
            if (this.replaceComboHandler) {
                this.replacedComboHandler(event);
            } else {
                this.handler.invoke((Event)event);
            }
            if (event.getEntityLiving() instanceof EntityLiving && (follow_range = ((EntityLiving)event.getEntityLiving()).func_110148_a(SharedMonsterAttributes.field_111265_b)).func_111127_a(BetterSurvivalHandler.this.UUID_BLINDNESS) != null) {
                double sightValue;
                if (!ModConfig.server.bettersurvival.mobBlindness) {
                    follow_range.func_188479_b(BetterSurvivalHandler.this.UUID_BLINDNESS);
                    return;
                }
                EntityEntry entityEntry = EntityRegistry.getEntry(event.getEntityLiving().getClass());
                if (entityEntry != null) {
                    String mobType = entityEntry.getRegistryName().toString();
                    String[] mobBlacklist = ModConfig.server.bettersurvival.mobBlindnessBlacklist;
                    for (int i = 0; i < mobBlacklist.length; ++i) {
                        if (!mobType.equals(mobBlacklist[i])) continue;
                        follow_range.func_188479_b(BetterSurvivalHandler.this.UUID_BLINDNESS);
                        return;
                    }
                }
                if ((sightValue = ModConfig.server.bettersurvival.mobBlindnessPercentage) != 80.0) {
                    follow_range.func_188479_b(BetterSurvivalHandler.this.UUID_BLINDNESS);
                    follow_range.func_111121_a(new AttributeModifier(BetterSurvivalHandler.this.UUID_BLINDNESS, "blind", sightValue *= -0.01, 1));
                }
            }
        }
    }

    public class BSEnchantment {
        private IEventListener handler;
        private boolean replaceEnchantment;

        public BSEnchantment(IEventListener handler) {
            this.handler = handler;
            this.replaceEnchantment = ModConfig.server.bettersurvival.replaceEnchantmentHandler;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        private void replacedEnchantment(LivingEvent.LivingUpdateEvent event) {
            EntityPlayer player;
            int vitalityLevel;
            EntityLivingBase living = event.getEntityLiving();
            if (BetterSurvivalHandler.this.reflector.o_ConfigHandler_agilitylevel > 0) {
                int agilityLevel = EnchantmentHelper.func_185284_a((Enchantment)BetterSurvivalHandler.this.reflector.o_ModEnchantments_agility, (EntityLivingBase)living);
                if (agilityLevel > 0) {
                    IAttributeInstance movement_speed = living.func_110148_a(SharedMonsterAttributes.field_111263_d);
                    double strength = 0.01 * (double)agilityLevel;
                    AttributeModifier modifier = new AttributeModifier(BetterSurvivalHandler.this.UUID_SPEED, "agility", strength, 0);
                    if (!movement_speed.func_180374_a(modifier)) {
                        movement_speed.func_111121_a(modifier);
                    } else if (movement_speed.func_111127_a(BetterSurvivalHandler.this.UUID_SPEED).func_111164_d() != strength) {
                        movement_speed.func_188479_b(BetterSurvivalHandler.this.UUID_SPEED);
                        movement_speed.func_111121_a(modifier);
                    }
                } else {
                    living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(BetterSurvivalHandler.this.UUID_SPEED);
                }
            } else {
                living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(BetterSurvivalHandler.this.UUID_SPEED);
            }
            if (BetterSurvivalHandler.this.reflector.o_ConfigHandler_vitalitylevel > 0 && living instanceof EntityPlayer && (vitalityLevel = EnchantmentHelper.func_185284_a((Enchantment)BetterSurvivalHandler.this.reflector.o_ModEnchantments_vitality, (EntityLivingBase)living)) > 0 && (player = (EntityPlayer)living).func_71024_bL().func_75116_a() >= 18 && player.func_130014_f_().func_82736_K().func_82766_b("naturalRegeneration") && player.func_110143_aJ() < player.func_110138_aP() && player.field_70173_aa % (40 / vitalityLevel) == 0) {
                player.func_70691_i(1.0f);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
        public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
            if (this.replaceEnchantment) {
                this.replacedEnchantment(event);
            } else {
                this.handler.invoke((Event)event);
            }
        }
    }
}

